/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.entity.pathfinding.PathingOptions;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.combat.AttackMoveAI;
import com.minecolonies.coremod.entity.ai.combat.CombatUtils;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.entity.pathfinding.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobCanSee;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobMoveToLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.items.IItemHandler;

public class RangerCombatAI
extends AttackMoveAI<EntityCitizen> {
    private static final VisibleCitizenStatus ARCHER_COMBAT = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/archer_combat.png"), "com.minecolonies.gui.visiblestatus.archer_combat");
    private final AbstractEntityAIGuard parentAI;
    private static final double COMBAT_SPEED = 1.0;
    private static final double ARROW_EXTRA_DAMAGE = 2.0;
    private static final int BOW_HOLDING_DELAY = 10;
    private static final int GUARD_BONUS_RANGE = 10;
    private static final int FLEE_CHANCE = 3;
    private final PathingOptions combatPathingOptions;

    public RangerCombatAI(EntityCitizen owner, ITickRateStateMachine stateMachine, AbstractEntityAIGuard parentAI) {
        super(owner, stateMachine);
        this.parentAI = parentAI;
        this.combatPathingOptions = new PathingOptions();
        this.combatPathingOptions.setEnterDoors(true);
        this.combatPathingOptions.setCanOpenDoors(true);
        this.combatPathingOptions.setCanSwim(true);
        this.combatPathingOptions.withOnPathCost(0.8);
        this.combatPathingOptions.withJumpCost(0.01);
        this.combatPathingOptions.withDropCost(0.9);
    }

    @Override
    public boolean canAttack() {
        int weaponSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)((EntityCitizen)this.user).getInventoryCitizen(), ToolType.BOW, 0, ((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getMaxToolLevel());
        if (weaponSlot != -1) {
            ((EntityCitizen)this.user).getCitizenItemHandler().setHeldItem(Hand.MAIN_HAND, weaponSlot);
            if (this.nextAttackTime - 10L >= ((EntityCitizen)this.user).field_70170_p.func_82737_E()) {
                ((EntityCitizen)this.user).func_184598_c(Hand.MAIN_HAND);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void doAttack(LivingEntity target) {
        if (((EntityCitizen)this.user).func_70068_e((Entity)target) < 7.0) {
            if (((EntityCitizen)this.user).func_70681_au().nextInt(3) == 0 && !((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getTask().equals("com.minecolonies.core.guard.setting.guard")) {
                ((EntityCitizen)this.user).getNavigation().moveAwayFromLivingEntity((Entity)target, this.getAttackDistance() / 2.0, this.getCombatMovementSpeed());
            }
        } else {
            ((EntityCitizen)this.user).getNavigation().func_75499_g();
        }
        ((EntityCitizen)this.user).getCitizenData().setVisibleStatus(ARCHER_COMBAT);
        ((EntityCitizen)this.user).func_184609_a(Hand.MAIN_HAND);
        int amountOfArrows = 1;
        if (((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.DOUBLE_ARROWS) > 0.0 && ((EntityCitizen)this.user).func_70681_au().nextDouble() < ((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.DOUBLE_ARROWS)) {
            ++amountOfArrows;
        }
        for (int i = 0; i < amountOfArrows; ++i) {
            int k;
            ItemStack bow;
            AbstractArrowEntity arrow = CombatUtils.createArrowForShooter(this.user);
            if (((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARROW_PIERCE) > 0.0) {
                arrow.func_213872_b((byte)2);
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)(bow = ((EntityCitizen)this.user).func_184586_b(Hand.MAIN_HAND))) > 0) {
                arrow.func_70015_d(100);
            }
            if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)bow)) > 0) {
                arrow.func_70240_a(k);
            }
            double damage = this.calculateDamage();
            arrow.func_70239_b(damage);
            float chance = 15.0f / (float)(((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) + 1);
            CombatUtils.shootArrow(arrow, target, chance);
            ((EntityCitizen)this.user).func_184185_a(SoundEvents.field_187866_fi, 1.0f, (float)SoundUtils.getRandomPitch(((EntityCitizen)this.user).func_70681_au()));
        }
        target.func_70604_c(this.user);
        ((EntityCitizen)this.user).getCitizenItemHandler().damageItemInHand(Hand.MAIN_HAND, 1);
        ((EntityCitizen)this.user).func_184602_cy();
        ((EntityCitizen)this.user).decreaseSaturationForContinuousAction();
    }

    @Override
    protected double getAttackDistance() {
        int attackDist = 10;
        if (((EntityCitizen)this.user).getCitizenData().getWorkBuilding() != null) {
            attackDist += ((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getBuildingLevel();
        }
        if (((EntityCitizen)this.user).getCitizenData() != null) {
            attackDist = (int)((float)attackDist + (float)((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) / 50.0f * 15.0f);
        }
        attackDist = Math.min(attackDist, 24);
        if (this.target != null) {
            attackDist = (int)((double)attackDist + (((EntityCitizen)this.user).func_226278_cu_() - this.target.func_226278_cu_()));
        }
        if (((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getTask().equals("com.minecolonies.core.guard.setting.guard")) {
            attackDist += 10;
        }
        return attackDist;
    }

    @Override
    protected int getAttackDelay() {
        int attackDelay = 60 - ((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability);
        return Math.max(attackDelay, 20);
    }

    private double calculateDamage() {
        int slot;
        int damage = ((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Agility) / 5;
        ItemStack heldItem = ((EntityCitizen)this.user).func_184586_b(Hand.MAIN_HAND);
        damage = (int)((double)damage + (double)EnchantmentHelper.func_152377_a((ItemStack)heldItem, (CreatureAttribute)this.target.func_70668_bt()) / 2.5);
        damage += EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)heldItem);
        damage = (int)((double)damage + ((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARCHER_DAMAGE));
        if (((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARCHER_USE_ARROWS) > 0.0 && (slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)((EntityCitizen)this.user).getInventoryCitizen(), item -> item.func_77973_b() instanceof ArrowItem)) != -1 && !ItemStackUtils.isEmpty(((EntityCitizen)this.user).getInventoryCitizen().extractItem(slot, 1, false)).booleanValue()) {
            damage = (int)((double)damage + 2.0);
        }
        if ((double)((EntityCitizen)this.user).func_110143_aJ() <= (double)((EntityCitizen)this.user).func_110138_aP() * 0.2) {
            damage *= 2;
        }
        return (double)(2 + damage) * (Double)MineColonies.getConfig().getServer().rangerDamageMult.get();
    }

    @Override
    protected PathResult moveInAttackPosition(LivingEntity target) {
        if (((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getTask().equals("com.minecolonies.core.guard.setting.guard")) {
            PathJobCanSee job = new PathJobCanSee(this.user, target, ((EntityCitizen)this.user).field_70170_p, ((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getGuardPos(), 40);
            PathResult pathResult = ((MinecoloniesAdvancedPathNavigate)((EntityCitizen)this.user).getNavigation()).setPathJob(job, null, this.getCombatMovementSpeed());
            job.setPathingOptions(this.combatPathingOptions);
            return pathResult;
        }
        PathJobMoveToLocation job = new PathJobMoveToLocation(((EntityCitizen)this.user).field_70170_p, AbstractPathJob.prepareStart(this.user), target.func_233580_cy_(), 200, this.user);
        PathResult pathResult = ((MinecoloniesAdvancedPathNavigate)((EntityCitizen)this.user).getNavigation()).setPathJob(job, null, this.getCombatMovementSpeed());
        job.setPathingOptions(this.combatPathingOptions);
        return pathResult;
    }

    protected double getCombatMovementSpeed() {
        double levelAdjustment = (double)((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Agility) * 0.01;
        levelAdjustment += (double)(((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getBuildingLevel() * 2 - 1) * 0.01;
        levelAdjustment = Math.min(levelAdjustment, 0.3);
        return 1.0 + levelAdjustment;
    }

    @Override
    protected boolean isAttackableTarget(LivingEntity entity) {
        return AbstractEntityAIGuard.isAttackableTarget((AbstractEntityCitizen)this.user, entity);
    }

    @Override
    protected boolean isWithinPersecutionDistance(LivingEntity target) {
        return this.parentAI.isWithinPersecutionDistance(target.func_233580_cy_(), this.getAttackDistance());
    }

    @Override
    protected boolean skipSearch(LivingEntity entity) {
        EntityCitizen citizen;
        if (entity instanceof EntityCitizen && (citizen = (EntityCitizen)entity).getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && ((AbstractJobGuard)citizen.getCitizenJobHandler().getColonyJob()).isAsleep() && ((EntityCitizen)this.user).func_70635_at().func_75522_a((Entity)citizen)) {
            this.parentAI.setWakeCitizen(citizen);
            return true;
        }
        return false;
    }

    @Override
    protected void onTargetChange() {
        CombatUtils.notifyGuardsOfTarget((AbstractEntityCitizen)this.user, this.target, 1600);
    }

    @Override
    protected int getYSearchRange() {
        if (((AbstractBuildingGuards)((EntityCitizen)this.user).getCitizenData().getWorkBuilding()).getTask().equals("com.minecolonies.core.guard.setting.guard")) {
            return 28;
        }
        return 3;
    }

    @Override
    protected void onTargetDied(LivingEntity entity) {
        this.parentAI.incrementActionsDoneAndDecSaturation();
        ((EntityCitizen)this.user).getCitizenExperienceHandler().addExperience(15.0);
    }
}

